/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class WriteCacheVirtualFile
extends AbstractProxyVirtualFile
implements IState {
    private static final int STATE_VERSION = 0;
    private final SortedSet<Block> blocks = new TreeSet<Block>();
    private boolean compareAtWrite;

    public WriteCacheVirtualFile(IVirtualFile vFile) {
        super(vFile);
    }

    public WriteCacheVirtualFile(IVirtualFile vFile, boolean compareAtWrite) {
        super(vFile);
        this.compareAtWrite = compareAtWrite;
    }

    private void mergeBlocks(Block block1, Block block2) {
        long mergedStart = Math.min(block1.start, block2.start);
        long mergedEnd = Math.max(block1.end, block2.end);
        byte[] mergedData = new byte[(int)(mergedEnd - mergedStart)];
        System.arraycopy(block1.data, 0, mergedData, (int)(block1.start - mergedStart), block1.getLength());
        System.arraycopy(block2.data, 0, mergedData, (int)(block2.start - mergedStart), block2.getLength());
        Block mergedBlock = new Block(mergedStart, mergedEnd, mergedData);
        this.blocks.remove(block1);
        this.blocks.remove(block2);
        this.blocks.add(mergedBlock);
    }

    private void addBlock(Block blockToBeAdded) {
        if (blockToBeAdded.getLength() <= 0) {
            return;
        }
        for (Block block : this.blocks) {
            if (block.isFollowing(blockToBeAdded) || blockToBeAdded.isFollowing(block)) {
                this.mergeBlocks(block, blockToBeAdded);
                return;
            }
            if (block.isAfter(blockToBeAdded)) break;
            if (!block.isOverlapping(blockToBeAdded)) continue;
            this.mergeBlocks(block, blockToBeAdded);
            return;
        }
        this.blocks.add(blockToBeAdded);
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        if (this.blocks.isEmpty()) {
            return this.vFile.ioRead(outputPointer, outputLength);
        }
        long position = this.vFile.getPosition();
        int outputOffset = 0;
        int totalReadLength = 0;
        for (Block block : this.blocks) {
            if (block.isAfter(position)) {
                int length = Math.min(outputLength, (int)(block.start - position));
                int readLength = this.vFile.ioRead(new TPointer(outputPointer, outputOffset), length);
                if (readLength < 0) {
                    return readLength;
                }
                outputOffset += readLength;
                outputLength -= readLength;
                totalReadLength += readLength;
                position = this.vFile.getPosition();
            }
            if (block.isContaining(position)) {
                int before = (int)(position - block.start);
                int length = Math.min(outputLength, block.getLength() - before);
                outputPointer.setArray(outputOffset, block.data, before, length);
                outputOffset += length;
                outputLength -= length;
                totalReadLength += length;
                position = this.vFile.ioLseek(position + (long)length);
                continue;
            }
            if (!block.isAfter(position)) continue;
            break;
        }
        if (outputLength > 0) {
            int readLength = this.vFile.ioRead(new TPointer(outputPointer, outputOffset), outputLength);
            if (readLength < 0) {
                return readLength;
            }
            totalReadLength += readLength;
        }
        return totalReadLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        if (this.blocks.isEmpty()) {
            return this.vFile.ioRead(outputBuffer, outputOffset, outputLength);
        }
        long position = this.vFile.getPosition();
        int totalReadLength = 0;
        for (Block block : this.blocks) {
            if (block.isAfter(position)) {
                int length = Math.min(outputLength, (int)(block.start - position));
                int readLength = this.vFile.ioRead(outputBuffer, outputOffset, length);
                if (readLength < 0) {
                    return -1;
                }
                outputOffset += readLength;
                outputLength -= readLength;
                totalReadLength += readLength;
                position = this.vFile.getPosition();
            }
            if (block.isContaining(position)) {
                int before = (int)(position - block.start);
                int length = Math.min(outputLength, block.getLength() - before);
                System.arraycopy(block.data, before, outputBuffer, outputOffset, length);
                outputOffset += length;
                outputLength -= length;
                totalReadLength += length;
                position = this.vFile.ioLseek(position + (long)length);
                continue;
            }
            if (!block.isAfter(position)) continue;
            break;
        }
        if (outputLength > 0) {
            int readLength = this.vFile.ioRead(outputBuffer, outputOffset, outputLength);
            if (readLength < 0) {
                return readLength;
            }
            totalReadLength += readLength;
        }
        return totalReadLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        long position = this.vFile.getPosition();
        byte[] data = inputPointer.getArray8(inputLength);
        boolean ignoreWrite = false;
        if (this.compareAtWrite) {
            byte[] targetData = new byte[inputLength];
            this.vFile.ioRead(targetData, 0, inputLength);
            ignoreWrite = Utilities.equals(data, 0, targetData, 0, inputLength);
        } else {
            this.vFile.ioLseek(position + (long)inputLength);
        }
        if (!ignoreWrite) {
            Block block = new Block(position, position + (long)inputLength, data);
            this.addBlock(block);
        }
        return inputLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        long position = this.vFile.getPosition();
        boolean ignoreWrite = false;
        if (this.compareAtWrite) {
            byte[] targetData = new byte[inputLength];
            this.vFile.ioRead(targetData, 0, inputLength);
            ignoreWrite = Utilities.equals(inputBuffer, inputOffset, targetData, 0, inputLength);
        } else {
            this.vFile.ioLseek(position + (long)inputLength);
        }
        if (!ignoreWrite) {
            byte[] data = new byte[inputLength];
            System.arraycopy(inputBuffer, inputOffset, data, 0, inputLength);
            Block block = new Block(position, position + (long)inputLength, data);
            this.addBlock(block);
        }
        return inputLength;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.compareAtWrite = stream.readBoolean();
        int numberBlocks = stream.readInt();
        this.blocks.clear();
        for (int i = 0; i < numberBlocks; ++i) {
            Block block = new Block();
            block.read(stream);
            this.blocks.add(block);
        }
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeBoolean(this.compareAtWrite);
        int numberBlocks = this.blocks.size();
        stream.writeInt(numberBlocks);
        for (Block block : this.blocks) {
            block.write(stream);
        }
        super.write(stream);
    }

    @Override
    public String toString() {
        return String.format("WriteCacheVirtualFile %s", this.vFile);
    }

    private static class Block
    implements Comparable<Block>,
    IState {
        private static final int STATE_VERSION = 0;
        private long start;
        private long end;
        private byte[] data;

        public Block() {
        }

        public Block(long start, long end, byte[] data) {
            this.start = start;
            this.end = end;
            this.data = data;
        }

        public boolean isContaining(long position) {
            return this.start <= position && position < this.end;
        }

        public boolean isBefore(long position) {
            return this.end <= position;
        }

        public boolean isAfter(long position) {
            return position < this.start;
        }

        public boolean isBefore(Block block) {
            return this.isBefore(block.start);
        }

        public boolean isAfter(Block block) {
            return this.isAfter(block.end);
        }

        public boolean isOverlapping(Block block) {
            return !this.isBefore(block) && !this.isAfter(block);
        }

        public boolean isFollowing(Block block) {
            return this.start == block.end;
        }

        public int getLength() {
            return (int)(this.end - this.start);
        }

        @Override
        public int compareTo(Block block) {
            return Long.compare(this.start, block.start);
        }

        @Override
        public void read(StateInputStream stream) throws IOException {
            stream.readVersion(0);
            this.start = stream.readLong();
            this.end = stream.readLong();
            this.data = stream.readBytesWithLength();
        }

        @Override
        public void write(StateOutputStream stream) throws IOException {
            stream.writeVersion(0);
            stream.writeLong(this.start);
            stream.writeLong(this.end);
            stream.writeBytesWithLength(this.data);
        }

        public String toString() {
            return String.format("Block 0x%X-0x%X(length=0x%X)", this.start, this.end, this.getLength());
        }
    }
}

